definition module dialogLayout;


//	Version 0.8 to 1.0


from	mac_types		import ::Rect,::DialogPtr,::MacMenuHandle;
from	deltaFont		import ::Font;
from	deltaPicture	import ::DrawFunction,::Picture;
import	commonDef;


::	*DialogState *s *io;
::	DialogInfo;

    
::	DialogDef *s *io
	=  PropertyDialog DialogId DialogTitle [DialogAttribute] (SetFunction s io)
	                  (ResetFunction s io) [DialogItem s io]
	|  CommandDialog  DialogId DialogTitle [DialogAttribute]
	                  DialogItemId [DialogItem s io]
	|  AboutDialog    ApplicationName PictureDomain [DrawFunction] (AboutHelpDef s io);

::	DialogId		:== Int;
::	DialogTitle		:== String;
::	DialogAttribute
	=	DialogPos    Measure Measure
	|	DialogSize   Measure Measure
	|	DialogMargin Measure Measure
	|	ItemSpace    Measure Measure
	|	StandByDialog;
::	Measure     	=	MM Real | Inch Real | Pixel Int;

::	ApplicationName	:== String;
::	AboutHelpDef *s *io
	=	AboutHelp ItemTitle (AboutHelpFunction s io)
	|	NoHelp;
::	AboutHelpFunction *s *io :== s -> *(io -> *(s,io));

::	DialogItem *s *io
	=	DialogButton	 DialogItemId ItemPos ItemTitle SelectState
										(ButtonFunction s io)
	|	DialogIconButton DialogItemId ItemPos PictureDomain IconLook SelectState
										(ButtonFunction s io)
	|	StaticText		 DialogItemId ItemPos String
	|	DynamicText		 DialogItemId ItemPos TextWidth String
	|	EditText		 DialogItemId ItemPos TextWidth NrEditLines String
	|	DialogPopUp		 DialogItemId ItemPos SelectState DialogItemId
										[RadioItemDef s io]
	|	RadioButtons	 DialogItemId ItemPos RowsOrColumns DialogItemId
										[RadioItemDef s io]
	|	CheckBoxes		 DialogItemId ItemPos RowsOrColumns
										[CheckBoxDef s io]
	|	Control			 DialogItemId ItemPos PictureDomain SelectState
										ControlState ControlLook ControlFeel
										(DialogFunction s io);

::	DialogItemId	:==	Int;
::	ItemPos			=	Left | Center | Right | RightTo DialogItemId
					|	Below DialogItemId | XOffset DialogItemId Measure
					|	YOffset DialogItemId Measure | XY Measure Measure
					|	ItemBox Int Int Int Int;
::	IconLook		:== SelectState -> [DrawFunction];
::	TextWidth		:== Measure;
::	NrEditLines		:== Int;
::	RowsOrColumns	=	Rows Int | Columns Int;

::	RadioItemDef *s *io
	=	RadioItem DialogItemId ItemTitle SelectState			(DialogFunction s io);
::	CheckBoxDef	 *s *io
	=	CheckBox  DialogItemId ItemTitle SelectState MarkState	(DialogFunction s io);

::	ControlState	=	BoolCS Bool | IntCS Int | RealCS Real | StringCS String
					|	PairCS ControlState ControlState | ListCS [ControlState];
::	ControlLook		:== SelectState -> ControlState -> [DrawFunction];
::	ControlFeel		:== MouseState  -> ControlState -> (ControlState,[DrawFunction]);

::	SetFunction    *s *io :== ButtonFunction s io;
::	ResetFunction  *s *io :== ButtonFunction s io;
::	DialogFunction *s *io
	:== DialogInfo -> (DialogState s io) -> DialogState s io;
::	ButtonFunction *s *io
	:== DialogInfo -> (s -> *(io -> *(s,io)));

::	NoticeDef		=	Notice [String] NoticeButtonDef [NoticeButtonDef];
::	NoticeButtonDef	=	NoticeButton NoticeButtonId ItemTitle;
::	NoticeButtonId	:==	Int;

::	ItemInfo		:== (	[(DialogItemId,String)],
							[(DialogItemId,DialogItemId)],
							[(DialogItemId,[(DialogItemId,Bool)])],
							[(DialogItemId,ControlState)]	);

::	DialogRep	 *s *io
	:==	(	!DialogHandle s io,
			!DialogPtr	);
::	NoticeHandle *s *io
	=	NoticeH Rect [DialogItem s io];
::	DialogHandle *s *io
	=	DialogH DialogId DialogTitle DialogMode Rect [PopUpHandle]
			[DialogItem s io] DialogDefInfo;
::	DialogMode
	=	Modal
	|	Modeless;
::	DialogDefInfo
	=	DialogRest DialogKind [DialogAttribute] DialogItemId;
	//	The last argument is the id of the default button.
::	DialogKind
	=	Property
	|	Command;
::	PopUpHandle
	:==	(	!DialogItemId,
			!MacMenuHandle	);


CreateDialogState		:: !(!DialogRep s io, !*Toolbox) -> DialogState s io;
UnpackDialogState		:: !(DialogState s io) -> (!DialogRep s io, !*Toolbox);
DialogInfoToItemInfo	:: !DialogInfo -> ItemInfo;
DialogHandleToDialogInfo:: !(DialogHandle s io) -> DialogInfo;

     
LineHeight	:== 16;		// The line height of the Macintosh dialog font: Plain Chicago 12.
BaseOfs		:== 12;		// Ascent+Leading of the Macintosh dialog font.
MinButWid	:== 55;
ButHgt		:== 20;

    
CalcItemBoxes		:: !(!Int,!Int) !(!Int,!Int) ![DialogItem s io]
					-> (!Int,!Int,![DialogItem s io]);
DialogFont			:: Font;
HorMeasureToPixels	:: !Measure  -> Int;
VerMeasureToPixels	:: !Measure  -> Int;
